<?php
defined('PF_VERSION') OR exit('Access denied');
$current = isset($_GET['current']) ? $_GET['current'] : '';
?>
<div class="row pull-right btnTop">
    <div class="col-md-12">
        <?php
        add_toolbar_button(form_button("<i class='fa fa-check'></i> " . __('Save', 'post'), array('class' => 'btn btn-primary btnSave')));
        add_toolbar_button(form_button(" " . __('Cancel', 'post'), array('onclick' => "window.location='" . admin_url(array('admin-page' => 'post', 'current' => $current, 'sub_page' => 'category'), false) . "'", 'class' => 'btn btn-default')));
        ?>
    </div>
</div><!--end button-->
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="fa fa-list"></i> <?php echo __('Edit Category', 'post'); ?>
                </h3>
            </div>
            <div class="panel-body">
                <form action="<?php echo admin_url('&act=edit') ?>" class="form-horizontal" method="post" role="form">
                    <table class="table table-bordered form">
                        <colgroup>
                            <col span="1" class="col-md-2 header">
                        </colgroup>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Name', 'post') ?> <span>*</span></label>
                            </td>
                            <td class="<?php echo state_validator('name', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'name', 'class' => 'form-control', 'tabindex' => 1, 'value' => e($cate->category_name)));
                                echo form_input(array('name' => 'id', 'type' => 'hidden', 'value' => $cate->id));
                                echo alert_error_validator('name', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Parent', 'post') ?> <span>*</span></label>
                            </td>
                            <td class="<?php echo state_validator('parent', $validated); ?>">
                                <select name="parent" class="form-control">
                                    <?php
                                    foreach ($categories as $category) :
                                        ?>
                                        <option value="<?php echo $category[0] ?>"<?php echo $cate->category_parent == $category[0] ? 'selected="selected"' : '' ?>>
                                            <?php echo $category[1] ?>
                                        </option>
                                        <?php
                                    endforeach;
                                    ?>
                                </select>
                                <?php
                                echo alert_error_validator('parent', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Status', 'post') ?> <span>*</span></label>
                            </td>
                            <td class="<?php echo state_validator('status', $validated); ?>">
                                <?php
                                echo form_dropdown('status', $status, $cate->category_status, "class='form-control' tabindex='3'");
                                echo alert_error_validator('status', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Description', 'post') ?> </label>
                            </td>
                            <td class="<?php echo state_validator('description', $validated); ?>">
                                <?php
                                echo form_textarea(array('name' => 'description', 'class' => 'form-control', 'tabindex' => 3, 'rows' => 4), e($cate->category_description));
                                echo alert_error_validator('description', $validated);
                                ?> 
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>
<?php
require_once ABSPATH . '/includes/common/plugin/views/alert.php';
